﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Data.Linq;
using System.Web;
using System.Web.UI.WebControls;
using VeteransAffairs.Registries.Business;
using VeteransAffairs.Registries.BusinessManager;
using VeteransAffairs.Registries.BusinessManager.TBI;

/// <summary>
/// Summary description for MenuBuilder
/// </summary>
public static class MenuBuilder
{

    /// <summary>
    /// Builds left menu based on top menu location and pages accessible by user
    /// </summary>
    /// <param name="horizontalMenu"></param>
    /// <param name="pageTopMenuItem"></param>
    /// <param name="leftMenu"></param>
    /// <param name="pageLeftMenuItem"></param>
    /// <param name="breadCrumb"></param>
    /// <param name="accessiblePageList"></param>
    public static void BuildDynamicNavigationItems(string currentURL, Menu horizontalMenu, string pageTopMenuItem, Menu leftMenu, string pageLeftMenuItem, Label breadCrumb, string[] accessiblePageList)
    {   
        //menu items that need name manipulated after breadcrumb is built
        MenuItem menuItemNewTBI = new MenuItem();
        int numNewItems = 0;
        MenuItem menuItemInProcessTBI = new MenuItem();
        int numInProcess = 0;
                      
        switch (pageTopMenuItem)
        {
            case "My Tasks":

                TBIReferralManager referralManager = new TBIReferralManager();

                numNewItems = referralManager.SelectByStatusCount(1,"", 0, 0);
                numInProcess = referralManager.SelectByStatusCount(2, "", 0, 0);

                //leftMenu.Items.Add(new MenuItem("Notices", "TBI NOTICES", "", "Notices.aspx"));

                //MenuItem parentReferral = new MenuItem("Referrals", "TBI REFERRAL");
                //parentReferral.Selectable = false;
                //leftMenu.Items.Add(parentReferral);
                
                //menuItemNewTBI = new MenuItem("New", "TBI REFERRAL", "", "Referrals.aspx?id=1");
                //parentReferral.ChildItems.Add(menuItemNewTBI);
                
                //menuItemInProcessTBI = new MenuItem("In Process", "TBI REFERRAL", "", "Referrals.aspx?id=2");
                //parentReferral.ChildItems.Add(menuItemInProcessTBI);

                //parentReferral.ChildItems.Add(new MenuItem("Completed", "TBI REFERRAL", "", "Referrals.aspx?id=3"));
                
                MenuItem parentPolyTrauma = new MenuItem("Polytrauma", "TBI POLYTRAUMA");
                parentPolyTrauma.Selectable = false;
                leftMenu.Items.Add(parentPolyTrauma);
                parentPolyTrauma.ChildItems.Add(new MenuItem("Add New", "TBI POLYTRAUMA", "", "PolyTraumaEntry.aspx?id=0"));
                parentPolyTrauma.ChildItems.Add(new MenuItem("View / Edit", "TBI POLYTRAUMA LIST", "", "PolyTraumaEntries.aspx"));

                break;
            case "Patients":

                //leftMenu.Items.Add(new MenuItem("", "TBI PATIENTS", "", "Patients.aspx"));
                ////leftMenu.Items.Add(new MenuItem("TBI Patients", "TBI PATIENTS", "", "Patients.aspx"));
                //leftMenu.Items.Add(new MenuItem("Polytrauma Patients", "TBI POLYTRAUMA PATIENTS", "", "PolyTraumaPatients.aspx"));

                break;
            case "Reporting":



                break;
            //case "Dashboard":

            //    leftMenu.Items.Add(new MenuItem("Main", "TBI DASHBOARD", "", "Dashboard.aspx"));

            //    break;
            case "Administration":

                leftMenu.Items.Add(new MenuItem("Users", "TBI ADMIN LIST USERS", "", "AdminListUsers.aspx"));
                leftMenu.Items.Add(new MenuItem("Role Matrix", "TBI ADMIN USER ROLE", "", "AdminEditUsersRoles.aspx"));
                leftMenu.Items.Add(new MenuItem("System Availability", "TBI_SYSTEM_AVAILABILITY", "", "AdminSystemAvailability.aspx"));
                leftMenu.Items.Add(new MenuItem("Instrument Activation", "TBI ADMIN INSTRUMENT LIST", "", "AdminEditInstruments.aspx"));

                break;
            default:

                leftMenu.Items.Add(new MenuItem("Top Menu Not Registered"));
                break;
               
        }

        //Disable all menu items
        foreach (MenuItem item in leftMenu.Items)
                ChangeMenuState(item, false);

        //Enable selection for the accessible items only
        for (int i = 0; i < accessiblePageList.GetLength(0); i++)
            ChangeMenuState(leftMenu.FindItem(accessiblePageList[i]), true);

        //SetMenuItemHighlight(leftMenu.Items, pageLeftMenuItem);

        BuildBreadCrumbDynamic(currentURL, pageTopMenuItem, leftMenu, pageLeftMenuItem, breadCrumb, accessiblePageList);

        menuItemNewTBI.Text += (numNewItems > 0 ? " (" + numNewItems.ToString() + ")" : "");
        menuItemInProcessTBI.Text += (numInProcess > 0 ? " (" + numInProcess.ToString() + ")" : "");

    }

    /// <summary>
    /// Builds bread crumb based item in selected menu
    /// </summary>
    /// <param name="horizontalMenu"></param>
    /// <param name="pageTopMenuItem"></param>
    /// <param name="leftMenu"></param>
    /// <param name="pageLeftMenuItem"></param>
    /// <param name="breadCrumb"></param>
    /// <param name="accessiblePageList"></param>
    public static void BuildBreadCrumbDynamic(string currentURL, string pageTopMenuItem, Menu leftMenu, string pageLeftMenuItem, Label breadCrumb, string[] accessiblePageList)
    {
        
        MenuItem currentMenuItem = null;

        //if (leftMenu.Items.Count > 0)
        //{
        //    currentMenuItem = leftMenu.Items[0];
        //}
        foreach (MenuItem item in leftMenu.Items)
        {
            currentMenuItem = SeachItemAndChildrenByURL(item, currentURL);
            if (currentMenuItem != null) break;
        }

        if (currentMenuItem == null)
        {
            currentMenuItem = leftMenu.FindItem(pageLeftMenuItem);
        }


        if (currentMenuItem != null)
        {
            if (currentMenuItem.Selectable)
            {
                currentMenuItem.Selected = true;
            }

            //initialize breadcrumb with currently selected menu item
            string breadCrumbPath = currentMenuItem.Text;

            //add to path all parents of selected menu item
            while (currentMenuItem.Parent != null)
            {
                //set current menutree location to parent
                currentMenuItem = currentMenuItem.Parent;

                breadCrumbPath = currentMenuItem.Text + " > " + breadCrumbPath;
            }

            //add top menu to beginning of breadcrumb
            breadCrumbPath = pageTopMenuItem + " > " + breadCrumbPath;

            breadCrumb.Text = breadCrumbPath;
        }
        else if (pageTopMenuItem != null)
        {
            //add top menu to beginning of breadcrumb
            breadCrumb.Text = pageTopMenuItem;
        }
    }

    public static MenuItem SeachItemAndChildrenByURL(MenuItem item, string URL)
    {
        MenuItem foundItem = null;

        string[] pathElems = HttpContext.Current.Request.Url.PathAndQuery.Split(new char[] { '/' });
        string pageName =
        pathElems[pathElems.Length - 1];

        //foreach (MenuItem elem in menu)
        //{
        if (item.NavigateUrl == pageName)
            return item;

        if (item.ChildItems.Count > 0)
        {
            foreach (MenuItem subitem in item.ChildItems)
            {
                foundItem = SeachItemAndChildrenByURL(subitem, pageName);
                if (foundItem != null)
                    return foundItem;
            }
        }

        return null;

    }

    /// <summary>
    /// Changes menu state recursively
    /// </summary>
    /// <param name="item"></param>
    /// <param name="flag"></param>
    private static void ChangeMenuState(MenuItem item, bool flag)
    {
        if (item != null)
        {
            if (flag == false) item.Selectable = flag;
            if (flag == true && item.ChildItems.Count == 0) item.Selectable = flag;
            if (item.ChildItems.Count > 0)
                foreach (MenuItem subitem in item.ChildItems)
                    ChangeMenuState(subitem, flag);
        }
    }

    /// <summary>
    /// Search and highlight appropriate menu item
    /// </summary>
    /// <param name="menu">Collection of Menu Items</param>
    /// <param name="value">Item to Search For</param>
    private static void SetMenuItemHighlight(MenuItemCollection menu, string value)
    {

        foreach (MenuItem elem in menu)
        {
            if (elem.Value == value)
            {
                if (elem.Selectable)
                {
                    elem.Selected = true;
                    break;
                }
            }

            if (elem.ChildItems.Count > 0)
                SetMenuItemHighlight(elem.ChildItems, value);
        }
    }

    public static string GetDefaultPageForUserRole()
    {
         UserAccountManager _user = (UserAccountManager)HttpContext.Current.User;

        if (_user.GetRoles().Contains((int)RoleCode.TBI_ADMINISTRATOR))
        {
            return ("Referrals.aspx?id=1");
        }
        else if (_user.GetRoles().Contains((int)RoleCode.TBI_EDITOR))
        {
            return ("Referrals.aspx?id=1");
        }
        else if (_user.GetRoles().Contains((int)RoleCode.TBI_READ_ONLY))
        {
            return ("Referrals.aspx?id=1");
        }
        else if (_user.GetRoles().Contains((int)RoleCode.TBI_POLYTRAUMA_EDITOR))
        {
            return ("PolyTraumaEntries.aspx");
        }
        else if (_user.GetRoles().Contains((int)RoleCode.TBI_POLYTRAUMA_READ_ONLY))
        {
            return ("PolyTraumaEntries.aspx");
        }
        else if (_user.GetRoles().Contains((int)RoleCode.TBI_REPORTING_USER_NATIONAL))
        {
            return ("DefaultReporting.aspx");
        }
        else if (_user.GetRoles().Contains((int)RoleCode.TBI_REPORTING_USER_STATION))
        {
            return ("DefaultReporting.aspx");
        }
        else if (_user.GetRoles().Contains((int)RoleCode.TBI_REPORTING_USER_VISN))
        {
            return ("DefaultReporting.aspx");
        }
        else
        {
            return "";
        }

    }

    /// <summary>
    /// This function sets the properties for my tasks menu item
    /// based on the user role.
    /// </summary>
    public static void SetMyTasksLink(Menu horizontalMenu)
    {
        string defaultPage = MenuBuilder.GetDefaultPageForUserRole();

        if (defaultPage == "") defaultPage = "Default.aspx";

        MenuItem myTaskMenuItem = horizontalMenu.FindItem("My Tasks");

        if (defaultPage == "DefaultReporting.aspx")
        {
            myTaskMenuItem.NavigateUrl = "";
            myTaskMenuItem.Selectable = false;
        }
        else
        {
            myTaskMenuItem.NavigateUrl = defaultPage;
        }
    }

    /// <summary>
    /// This function sets the properties for patient menu item
    /// based on the user role.
    /// </summary>
    public static void SetPatientLink(Menu horizontalMenu)
    {
        //Deprecated - TLB

        //UserAccountManager _user = (UserAccountManager)HttpContext.Current.User;

        //string patientMenuPage = ""; 
        
        //if (_user.GetRoles().Contains((int)RoleCode.TBI_ADMINISTRATOR)
        //        ||
        //    _user.GetRoles().Contains((int)RoleCode.TBI_EDITOR)
        //        ||
        //    _user.GetRoles().Contains((int)RoleCode.TBI_READ_ONLY))
        //{
        //    patientMenuPage = "Patients.aspx";
        //}
        //else if (_user.GetRoles().Contains((int)RoleCode.TBI_POLYTRAUMA_EDITOR)
        //            ||
        //        _user.GetRoles().Contains((int)RoleCode.TBI_POLYTRAUMA_READ_ONLY))
        //{
        //    patientMenuPage = "PolyTraumaPatients.aspx";
        //}

        //MenuItem myTaskMenuItem = horizontalMenu.FindItem("Patients");

        //myTaskMenuItem.NavigateUrl = patientMenuPage;

        //if (patientMenuPage == "")
        //{
        //    myTaskMenuItem.Selectable = false;
        //}
    }
    
 
}
